/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Data
{
    /// <summary>
    /// Class for Adler32 checksum computation.
    /// </summary>
    public class Adler32
    {
        private const int Base = 65521;

        private int checksum;

        /// <summary>
        /// The computed checksum.
        /// </summary>
        public int Checksum { get { return checksum; } }

        /// <summary>
        /// Creates a new instance. 
        /// </summary>
        public Adler32()
        {
            checksum = 1;
        }

        /// <summary>
        /// Updates the checksum with a subsequence of bytes from the specified array. 
        /// </summary>
        /// <param name="buffer">the array of bytes</param>
        /// <param name="first">the first index of the array</param>
        /// <param name="length">the length of the block to update</param>
        public void Update(byte[] buffer, int first, int length)
        {
            int s1 = checksum & 65535;
            int s2 = checksum >> 16;
            while (length > 0)
            {
                int n = length < 3800 ? length : 3800;
                length -= n;
                while (--n >= 0)
                {
                    s1 = s1 + (buffer[first++] & 255);
                    s2 = s2 + s1;
                }
                s1 %= Base;
                s2 %= Base;
            }
            checksum = (s2 << 16) | s1;
        }
    }
}
